// YoutubeTS Chrome Extension - Popup Script

document.addEventListener('DOMContentLoaded', function() {
    // Track extension usage
    console.log('YoutubeTS Extension Popup Opened');

    // Add click tracking for analytics (optional)
    const ctaButton = document.querySelector('.cta-button');
    if (ctaButton) {
        ctaButton.addEventListener('click', function() {
            console.log('User clicked Visit YoutubeTS.com');
        });
    }

    // Check if user is currently on YouTube
    chrome.tabs.query({ active: true, currentWindow: true }, function(tabs) {
        const currentTab = tabs[0];
        const statusDiv = document.querySelector('.status');

        if (currentTab && currentTab.url) {
            if (currentTab.url.includes('youtube.com/watch')) {
                // User is on a YouTube video page
                statusDiv.style.background = 'rgba(0, 217, 255, 0.2)';
                statusDiv.style.borderColor = 'rgba(0, 217, 255, 0.3)';
                statusDiv.innerHTML = `
                    <div class="status-icon">✓</div>
                    <div class="status-text">Ready to convert this video!</div>
                `;
            } else if (currentTab.url.includes('youtube.com')) {
                // User is on YouTube but not a video page
                statusDiv.innerHTML = `
                    <div class="status-icon">ℹ️</div>
                    <div class="status-text">Visit a YouTube video to see the button</div>
                `;
            } else {
                // User is not on YouTube
                statusDiv.style.background = 'rgba(255, 0, 85, 0.2)';
                statusDiv.style.borderColor = 'rgba(255, 0, 85, 0.3)';
                statusDiv.innerHTML = `
                    <div class="status-icon">⚠️</div>
                    <div class="status-text">Please visit YouTube to use this extension</div>
                `;
            }
        }
    });
});
