# YoutubeTS Chrome Extension - Video to Text

Convert YouTube videos to text instantly with one click!

## Features

- ✨ One-click button on YouTube video pages
- 🎨 Beautiful gradient design matching YoutubeTS brand
- 🪟 Opens transcript in popup window
- 🌐 Supports all languages
- 📥 Download transcripts as TXT, DOCX, or PDF
- ⚡ Fast and lightweight

## Installation for Testing (Developer Mode)

1. Download this folder or clone it
2. Open Chrome and go to `chrome://extensions/`
3. Enable "Developer mode" (toggle in top-right)
4. Click "Load unpacked"
5. Select the `chrome-extension` folder
6. The extension is now installed!

## How to Use

1. Visit any YouTube video (e.g., `https://www.youtube.com/watch?v=VIDEO_ID`)
2. Look for the **"Video To Text"** button (gradient pink/purple)
3. Click the button
4. A popup window opens with your transcript on YoutubeTS.com

## Files Structure

```
chrome-extension/
├── manifest.json          # Extension configuration
├── content.js            # Injects button on YouTube
├── style.css            # Button styling
├── popup.html           # Extension popup interface
├── popup.js            # Popup functionality
├── icons/
│   ├── icon16.png      # 16x16 icon
│   ├── icon48.png      # 48x48 icon
│   └── icon128.png     # 128x128 icon
└── README.md           # This file
```

## Publishing to Chrome Web Store

### Prerequisites

1. Google Developer account ($5 one-time registration fee)
2. Register at: https://chrome.google.com/webstore/devconsole

### Submission Steps

#### 1. Prepare Assets

**Store Listing Images Required:**

- **Icon**: 128x128 PNG (already created in `icons/` folder)
- **Small Promotional Tile**: 440x280 PNG
- **Marquee Promotional Tile**: 1400x560 PNG
- **Screenshots**: At least 1, max 5 (1280x800 or 640x400 PNG/JPG)

**Create Screenshots:**
- Screenshot 1: YouTube page with "Video To Text" button visible
- Screenshot 2: Popup window showing transcript on YoutubeTS.com
- Screenshot 3: Different video examples
- Screenshot 4: Mobile view (optional)
- Screenshot 5: Download options (optional)

#### 2. Prepare Package

```bash
# Navigate to extension directory
cd /home/youtubets/public_html/chrome-extension

# Create ZIP file
zip -r youtubets-extension-v1.0.0.zip . -x "*.DS_Store" -x "README.md" -x "*.git*"
```

#### 3. Store Listing Information

**Product Details:**
- **Name**: YoutubeTS - Video to Text
- **Summary**: Convert YouTube videos to text instantly with accurate transcripts
- **Description**:
```
Transform YouTube videos into text with just one click!

YoutubeTS is your perfect companion for converting YouTube video content into readable, downloadable transcripts.

KEY FEATURES:
✓ One-Click Access - Button appears on every YouTube video
✓ Multi-Language Support - Works with videos in any language
✓ Multiple Formats - Download as TXT, DOCX, or PDF
✓ Timestamp Support - Get transcripts with or without timestamps
✓ Free to Use - No registration required for basic features
✓ Fast & Accurate - Instant transcript generation

HOW IT WORKS:
1. Install the extension
2. Visit any YouTube video
3. Click the "Video To Text" button
4. Get your transcript instantly!

PERFECT FOR:
• Students taking notes from educational videos
• Content creators analyzing competitor content
• Researchers extracting data from video sources
• Anyone who prefers reading over watching
• Accessibility needs

PRIVACY:
We respect your privacy. No personal data is collected by this extension. It only reads YouTube video URLs to provide transcript services.

Need support? Visit https://youtubets.com/contact
```

**Category**: Productivity

**Language**: English (add more if needed)

**Developer Website**: https://youtubets.com

**Developer Email**: contact@youtubets.com

**Privacy Policy URL**: https://youtubets.com/p/privacy-policy

**Terms of Service URL**: https://youtubets.com/p/terms-of-service

#### 4. Privacy Practices

You'll need to disclose:
- **Data Usage**: "This extension does not collect any user data"
- **Permissions Justification**:
  - `activeTab`: To detect YouTube video pages
  - `scripting`: To inject the button on YouTube pages
  - `host_permissions (youtube.com)`: To work on YouTube website

#### 5. Submit for Review

1. Log in to Chrome Web Store Developer Dashboard
2. Click "New Item"
3. Upload the ZIP file
4. Fill in all store listing information
5. Upload screenshots and promotional images
6. Select distribution (Public)
7. Pay $5 fee (one-time, if first submission)
8. Submit for review

**Review Time**: Usually 1-3 business days

#### 6. After Approval

Once approved, your extension will be available at:
```
https://chrome.google.com/webstore/detail/[YOUR-EXTENSION-ID]
```

Add the "Install Extension" button on your website:
```html
<a href="https://chrome.google.com/webstore/detail/[YOUR-EXTENSION-ID]" target="_blank">
  <img src="chrome-web-store-badge.png" alt="Available in Chrome Web Store">
</a>
```

## Updating the Extension

1. Update version in `manifest.json` (e.g., "1.0.0" → "1.0.1")
2. Make your changes
3. Create new ZIP file
4. Upload to Chrome Web Store Developer Dashboard
5. Submit for review

## Support

For issues or feature requests:
- Website: https://youtubets.com
- Email: contact@youtubets.com

## License

© 2025 YoutubeTS. All rights reserved.

---

**Note**: Make sure your website (youtubets.com) has proper Privacy Policy and Terms of Service pages before submitting to Chrome Web Store.
